% A 2.1: Downsampling mit/ohne Anti-Aliasing-Filter
% bung Signalverarbeitung

clear % leeren des workspace
close all % alle plots schlieen
clc % leeren des comand window


faktor = 20; % Downsampling-Faktor

tmin = 0;   % Startzeit [s]
tmax = 1;   % Endzeit [s]


f1 = 2;     % 1. Signalfrequenz [Hz]
f2 = 45;    % 2. Signalfrequenz [Hz]

f0 = 1000;    % Abtastfrequenz [Hz]
T0 = 1/f0;    % Abtastzeit [sec]


kmin = ceil(tmin / T0); % erster Abtastzeitpunkt
kmax = floor(tmax / T0); % letzter Abtastzeitpunkt
k    = kmin:kmax; % Diskreter Zeitvektor k = t/T0

tc   = linspace(tmin,tmax,1000); % Pseudo-kontinuierlicher Zeitvektor in [sec]

y  = sin(2*pi*f1*k*T0) + sin(2*pi*f2*k*T0);  % Abgetastetes Signal
yc = sin(2*pi*f1*tc) + sin(2*pi*f2*tc);      % Ursprungssignal Signal


% hilft den plot direkt auf einer vernnfitgen Gre zu erzeugen
scrsz = get(0,'ScreenSize');
figure('Position',[scrsz(1) scrsz(2) 0.9*scrsz(3) 0.9*scrsz(4)])
sizeFont = 14;
set(gca,'fontsize',sizeFont)

subplot(4,1,1) % ursprngliches Signal
plot(tc/T0,yc,'-','markersize',10,'linewidth',2)
axis([min(k) max(k) -2 2])
title('Ursprungssignal','fontsize',sizeFont)
xlabel('Diskrete Zeit k','fontsize',sizeFont)

subplot(4,1,2) % abgetastes Signal
plot(k,y,'.-','markersize',10,'linewidth',2)
axis([min(k) max(k) -2 2])
title('Abgetastes Signal','fontsize',sizeFont)
xlabel('Diskrete Zeit k','fontsize',sizeFont)

subplot(4,1,3) % downsampling mit einfachem Ausschneiden
k1 = k(1:faktor:end);  y1 = y(1:faktor:end);
plot(k1,y1,'r.','markersize',20,'linewidth',2); hold on
plot(k1,y1,'r--','markersize',10,'linewidth',1)
axis([min(k) max(k) -2 2])
title('Downsampling OHNE Antialiasingfilter','fontsize',sizeFont)
xlabel('Diskrete Zeit k','fontsize',sizeFont)



subplot(4,1,4) % downsampling mit Antialiasingfilterung
k2 = decimate(k,faktor);
y2 = decimate(y,faktor);
plot(k2,y2,'k.','markersize',20,'linewidth', 2); hold on
plot(k2,y2,'k--','markersize',10,'linewidth',1)

axis([min(k) max(k) -2 2])
title('Downsampling MIT Antialiasingfilter','fontsize',sizeFont)
xlabel('Diskrete Zeit k','fontsize',sizeFont)




